/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage;

import com.aptana.core.logging.IdeLog;
import com.aptana.usage.IAnalyticsInfoManager;
import com.aptana.usage.IAnalyticsLogger;
import com.aptana.usage.IStudioAnalytics;
import com.aptana.usage.StudioAnalytics;
import com.aptana.usage.internal.AnalyticsInfoManager;
import com.aptana.usage.internal.AnalyticsLogger;
import com.aptana.usage.internal.SendPingJob;
import java.util.UUID;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class UsagePlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.usage";
    public static final String OLD_PLUGIN_ID = "com.aptana.db";
    private static UsagePlugin plugin;
    private SendPingJob job;
    private AnalyticsInfoManager fAnalyticsInfoManager;
    private AnalyticsLogger fAnalyticsLogger;
    private StudioAnalytics fStudioAnalytics;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.job = new SendPingJob();
        this.job.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.job != null) {
                this.job.shutdown();
                this.job = null;
            }
        }
        finally {
            this.fStudioAnalytics = null;
            this.fAnalyticsLogger = null;
            this.fAnalyticsInfoManager = null;
            plugin = null;
            super.stop(context);
        }
    }

    public static String getApplicationId() {
        String id = Platform.getPreferencesService().getString(PLUGIN_ID, "ide-id", null, null);
        boolean save = false;
        if (id == null && (id = Platform.getPreferencesService().getString(OLD_PLUGIN_ID, "ide-id", null, null)) != null) {
            save = true;
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
            save = true;
        }
        if (save) {
            IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(PLUGIN_ID);
            prefs.put("ide-id", id);
            try {
                prefs.flush();
            }
            catch (BackingStoreException e) {
                UsagePlugin.logError((Exception)((Object)e));
            }
        }
        return id;
    }

    public static UsagePlugin getDefault() {
        return plugin;
    }

    public static void logError(String message) {
        if (Platform.inDevelopmentMode()) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (String)message);
        }
    }

    public static void logError(Exception e) {
        if (Platform.inDevelopmentMode()) {
            IdeLog.logError((Plugin)UsagePlugin.getDefault(), (Throwable)e);
        }
    }

    public synchronized IStudioAnalytics getStudioAnalytics() {
        if (this.fStudioAnalytics == null) {
            this.fStudioAnalytics = new StudioAnalytics();
        }
        return this.fStudioAnalytics;
    }

    public synchronized IAnalyticsInfoManager getAnalyticsInfoManager() {
        if (this.fAnalyticsInfoManager == null) {
            this.fAnalyticsInfoManager = new AnalyticsInfoManager();
        }
        return this.fAnalyticsInfoManager;
    }

    public synchronized IAnalyticsLogger getAnalyticsLogger() {
        if (this.fAnalyticsLogger == null) {
            this.fAnalyticsLogger = new AnalyticsLogger(this.getStateLocation().append("events"));
        }
        return this.fAnalyticsLogger;
    }
}

